﻿param([string]$LocationURL,[string]$LocationName,[int]$LocationAlertTemp)
                  # Load MomScript API and PropertyBag function
                  $api = new-object -comObject 'MOM.ScriptAPI'
                  $bag = $api.CreatePropertyBag()

                  #Log script event that we are starting task
                  $api.LogScriptEvent("TooCold.ps1",6789,0, "Starting toocold.ps1 script")

                  [xml]$yr = Invoke-WebRequest -Uri $LocationURL
                  #Getting the latest observation
                  $Observations = $yr.SelectNodes("//observations").weatherstation | select-object -First 1
                  [int]$Obstemperature = $Observations.temperature.value
                  $temperatureUnit = $Observations.temperature.unit
                  if ($Obstemperature -lt $LocationAlertTemp){
                  $bag.AddValue("Result","BadCondition")
                  #$bag.AddValue("Description", "It is freaking cold observed temperature" + "$obstemperature" + "$temperatureUnit")
                  }
                  else{
                  $bag.addvalue("Result","GoodCondition")
                  }
                  $bag